unit DynRec;

interface
uses SysUtils, Dialogs, StdCtrls;

// ---------------------------------------------------------------
//    class ()
// ---------------------------------------------------------------

type TRnArr =  array of double;
     TMkRnd =  procedure (Slf : pointer);
     TShRnd =  procedure (Slf : pointer);
     RecCL  =  record
        fArray : TRnArr;
        fRMemo : TMemo;
        MakeRandomArr : TMkRnd;
        ShowRandomArr : TShRnd;
     end;
     TpRecCL   = ^RecCL;
     TpRnArr = ^TRnArr;

//   
function  MyCreate(RqCount : integer; RqRep : TMemo) : pointer;
//   
procedure MyFree(Slf : pointer);


implementation

// ---------------------------------------------------------------
//    . Slf   Self
// ---------------------------------------------------------------

//     
procedure MkRndArr(Slf : pointer);
var pRecCL : TpRecCL;
    Ind    : integer;
begin
   if Slf <> nil then pRecCL := Slf else Exit;
   for Ind := Low(pRecCL^.fArray) to High(pRecCL^.fArray)
   do pRecCL^.fArray[Ind] := Random;
end;

//    
procedure ShRndArr(Slf : pointer);
var pRecCL : TpRecCL;
    Ind    : integer;
begin
   if Slf <> nil then pRecCL := Slf else Exit;
   pRecCL^.fRMemo.Clear;
   for Ind := Low(pRecCL^.fArray) to High(pRecCL^.fArray)
   do pRecCL^.fRMemo.Lines.Add(FloatToStr(pRecCL^.fArray[Ind]));
end;

// ---------------------------------------------------------------
//    Create   Free
// ---------------------------------------------------------------

//   
function MyCreate(RqCount : integer; RqRep : TMemo) : pointer;
var pRecCL : TpRecCL;
begin
  Result := nil;
  try
     // !     ,  
     //  ,     
     //  New.  GetMem   
     //  ,      SetLength
     New(pRecCL);
     Result := pRecCL;
     if (pRecCL <> nil)
     then begin
        Randomize;
        with pRecCL^
        do begin
           if (RqCount > 0 ) then SetLength(fArray, RqCount);
           fRMemo := RqRep;
           MakeRandomArr := MkRndArr;
           ShowRandomArr := ShRndArr;
        end;
     end;
  except
     ShowMessage('   ');
  end;
end;

//   
procedure MyFree(Slf : pointer);
var pRecCL : TpRecCL;
begin
   if Slf <> nil then pRecCL := Slf else Exit;
   SetLength(pRecCL^.fArray, 0);
   Dispose(pRecCL);
end;


end.
